;
; ----------------------------------------------------------
;
;	obNCgCo[^PWMvO
;
;	PUSH-SW ɂ6iKPx
;
;	Copyright(c) 2004 By Yutaka Kyotani
;
; ----------------------------------------------------------
;
	LIST		P=12F675
	INCLUDE		"P12F675.INC"
	INCLUDE		"YKMACRO.MAC"

	__CONFIG	_CP_OFF & _CPD_OFF & _BODEN_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT

	RADIX		dec

;
;	CLK= CRU 4MHz	 1߂1uS
;	PWMFreq= 91Hz		 11000tcy (44tcy * 250)

PWM_MINVALUE	EQU	.30		; PWMŏJEgl
PWM_MAXVALUE	EQU	.250		; PWMőJEgl
KEY_MAXVALUE	EQU	.5		; ŏPx 0  5 őPx

CSTART_COUNT	EQU	.180		; X^[g̍őPxێJEg=180(2b)
EEP_SAVETIME	EQU	.90		; KeyȂȂĂSAVE܂ł̃^C}[

BRIGHT_SW	EQU	.0		; GPIO0= uCglXSW (0:PUSH)
BKLT_ON_OFF	EQU	.3		; GPIO3= obNCgON/OFF (1:ON)
PWM_OUT		EQU	.5		; GPIO5= PWMo (1:ON)

GET_OSCCAL	EQU	03FFH		; IV[^[Lu[Vl𓾂

WORK1		EQU	020H		; [N擪

INTSAVE		EQU	WORK1		; 荞݃[`ł̃ReLXgۑp
WSAVE		EQU	INTSAVE+00H	; 荞 Wregۑp
SSAVE		EQU	INTSAVE+01H	; 荞 STATUSۑp
FSAVE		EQU	INTSAVE+02H	; 荞 FSRۑp

WORK2		EQU	WORK1+03H
OUTVAL		EQU	WORK2+00H	; ϊli[p
PWMVAL1		EQU	WORK2+01H	; PWM ONJEgl
PWMVAL2		EQU	WORK2+02H	; PWM OFFJEgl
CSTART		EQU	WORK2+03H	; X^[g̍őPxێJEg
OLDKEY		EQU	WORK2+04H	; KEY PUSHԕۑp
KEYDIR		EQU	WORK2+05H	; KEY PUSHꂽ̑l(-1/1)
EEPCOUNT	EQU	WORK2+06H	; EEPROMۑ܂ł̎^C}[ 0:OFF

	ORG	00H
	GOTO	START

	ORG	04H
	GOTO	INTERRUPT

;
; ----------------------------------------------------------
;
;	C[`
;
; ----------------------------------------------------------
;
START:
	BANK0				; BANK 0 I
	CLRF	GPIO			; GPIO NA
	MOVLW	B'00000111'		; Rp[^͑SDigital[h
	MOVWF	CMCON
	BANK1				; BANK 1 I
	CALL	GET_OSCCAL
	MOVWF	OSCCAL
	MOVLW	B'00001001'		; GPIO  --543210 -> --ooIooI
	MOVWF	TRISIO
	MOVLW	B'01100000'		; ADCS210 ANS3 ANS2 ANS1 ANS0
	MOVWF	ANSEL			; 110 /64 0:D  0:D  0:D  0:D
	MOVLW	B'00000000'		; GPPU  INTEDG TOCS  TOSE PSA PS210
	MOVWF	OPTION_REG		; 0:ON  0:   0:INT 0: 0:T 000:1/2
	MOVLW	B'00000001'		; WPU5  WPU4  xxx3  WPU2  WPU1  WPU0
	MOVWF	WPU			; 0:OFF 0:OFF 0:OFF 0:OFF 0:OFF 1:ON
	CLRF	INTCON			; |[g`FW荞݃tONA
	CLRF	IOC			; 荞݂ɂX[v̖ڊoߑΉ
	BANK0				; BANK 0 I

	MOVLW	KEY_MAXVALUE		; KEY̌(MAXl)ZbgĂ
	MOVWF	OUTVAL
	MOVLW	.1			; KEY PUSHꂽ̑l1ɃZbg
	MOVWF	KEYDIR
	MOVLW	CSTART_COUNT		; őPxێJEgZbg
	MOVWF	CSTART
	CLRF	EEPCOUNT		; EEPROMۑ^C}[NA

LOOP_011:
	CALL	SLEEPCHK		; obNCgON/OFF(SLEEP) M̔
	CALL	PUT_PWM			; Nサ΂炭͍őPxo͂
	DJNZ	CSTART, LOOP_011
	CALL	EEP_READ		; EEPROMݒlǂݏo

LOOP_012:
	CALL	SLEEPCHK		; obNCgON/OFF(SLEEP) M̔
	CALL	GET_KEYVALUE		; őPxێԏI͐ݒlo
	CALL	PUT_PWM
	CALL	EEP_SAVECHK		; ^C}[`FbNEEPROMɐݒlۑ

	GOTO	LOOP_012

;
;	Key͏sl𓾂
;
GET_KEYVALUE:
	RRF	GPIO,W			; BRIGHT_SW = B0C
	RRF	OLDKEY,F		; B7: ŐVKEY  ÂKEY :B0
	MOVLW	B'11111000'		; ߋ4Clk܂ŉĂȂƂmF
	ANDWF	OLDKEY,W
	XORLW	B'01111000'		; ʂ0Ȃ牟ĂƂ݂Ȃ
	SKIPZ
	RETURN				; ĂȂ̂ł̂܂ܖ߂

	MOVLW	EEP_SAVETIME		; EEPROMɕۑ܂ł̎^C}[n
	MOVWF	EEPCOUNT

	MOVF	KEYDIR,W		; l(-1/1)ϊlɑ
	ADDWF	OUTVAL,W
	MOVWF	OUTVAL
	ADDLW	.0 - KEY_MAXVALUE - .1	; ől𒴂ĂȂ
	SKIPC
	RETURN				; NC: ϊl͔͈͓
					; C: ől𒴂Ă
	COMF	KEYDIR,F		; ω𔽓]
	INCF	KEYDIR,F
	MOVF	KEYDIR,W		; {̍̕l񑫂ĕ␳
	ADDWF	OUTVAL,F
	ADDWF	OUTVAL,F

	RETURN

;
;	ݒlPWMo͂
;
PUT_PWM:
	MOVF	OUTVAL,W		; PWM ONJEgle[u瓾
	CALL	PUTPWM_030
	MOVWF	PWMVAL1
					; PWM OFFJEgľvZ
	SUBLW	PWM_MAXVALUE + .1	; PWM_MAXVALUE + 1 - ONJEg
	MOVWF	PWMVAL2			; -1̂ +1Ă

	BSF	GPIO, PWM_OUT		; GP5= PWM OUT ON
PUTPWM_010:
	CALL	PWM_DELAY
	DJNZ	PWMVAL1, PUTPWM_010	; PWM ONJEgl܂Ŏԑ҂

	DJNZ	PWMVAL2, PUTPWM_020	; PWM OFFJEg 0
	RETURN				; 0ȂOFFȂ ON̂܂ܖ߂

PUTPWM_020:
	CLRF	GPIO			; PWM OUT OFF
PUTPWM_021:
	CALL	PWM_DELAY
	DJNZ	PWMVAL2, PUTPWM_021	; PWM OFFJEgl܂Ŏԑ҂
	BSF	GPIO, PWM_OUT		; GP5= PWM OUT ON

	RETURN

;
;	PWMϊpe[u
;
PUTPWM_030:
	ADDWF	PCL,F

	RETLW	PWM_MINVALUE		; 0: ŏPx
	RETLW	PWM_MINVALUE + ((PWM_MAXVALUE-PWM_MINVALUE) / 5) * 1
	RETLW	PWM_MINVALUE + ((PWM_MAXVALUE-PWM_MINVALUE) / 5) * 2
	RETLW	PWM_MINVALUE + ((PWM_MAXVALUE-PWM_MINVALUE) / 5) * 3
	RETLW	PWM_MINVALUE + ((PWM_MAXVALUE-PWM_MINVALUE) / 5) * 4
	RETLW	PWM_MAXVALUE		; 5: őPx

;
;	PWMp 41tcyDELAY
;
PWM_DELAY:
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1

	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1

	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	GOTO	$+1

	GOTO	$+1
	GOTO	$+1
	GOTO	$+1
	NOP
	RETURN

;
;	obNCgON/OFF(SLEEP) M̔
;
SLEEPCHK:
	BTFSC	GPIO, BKLT_ON_OFF
	RETURN				; |[gONȂ炻̂܂ܖ߂

	CLRF	GPIO			; |[gOFFȂ PWMo͂OFF
	CALL	PWM_DELAY

	MOVF	EEPCOUNT,W		; EEPROM݃JE^nĂ邩
	JZ	SLEEPCHK_001		; nĂȂȂ炻̂܂SLEEP

	MOVLW	.1			; EEPROMݏȂ瑦ݎs
	MOVWF	EEPCOUNT
	CALL	EEP_SAVECHK		; EEPROMɐݒlۑ
	CALL	EEP_SAVEWAIT		;    //   ݊܂ő҂

SLEEPCHK_001:
	CLRF	GPIO			; ēxGPIONA
	BANK1				; BANK 1 I
	CLRF	INTCON			; |[g`FW荞݃tONA
	CLRF	IOC
	BANK0				; BANK 0 I
	BTFSC	GPIO, BKLT_ON_OFF
	GOTO	START			; Ń|[gONȂR[hX^[g

	BANK1				; BANK 1 I
	BSF	INTCON, GPIE		; |[g`FW荞݋
	BSF	IOC, BKLT_ON_OFF
	BANK0				; BANK 0 IE
	SLEEP				; GIEONɂĂȂ̂Ŏ̖߂s
	GOTO	START			; SLEEP̋N̓R[hX^[g

;
;	^C}[`FbNEEPROMɐݒlۑ
;
EEP_SAVECHK:
	BTFSC	PIR1,EEIF		; EEPROM݊荞݃tOON
	GOTO	EEPSC_010		; ONȂۑǏns

EEPSC_001:
	MOVF	EEPCOUNT,W		; ^C}[ 0
	SKIPNZ
	RETURN				; 0Ȃ牽߂

	DECFSZ	EEPCOUNT,F		; ^C}[fNg
	RETURN				; 0ɂȂȂ΂̂܂ܖ߂
					; ^CAEg܂Key͂Ȃ
;;;	BCF	INTCON,GIE		; {͂Ŋ荞݂֎~
	BANK1				; BANK 1 I
	CLRF	EEADR			; ϊlۑ  0Ԓn
	MOVF	OUTVAL,W
	MOVWF	EEDATA
	BSF	EECON1,WREN		; Write Enable
	MOVLW	055H			; ܂̂܂Ȃ
	MOVWF	EECON2
	MOVLW	0AAH
	MOVWF	EECON2
	BSF	EECON1,WR		; Write Go!
	BANK0				; BANK 0 I
;;;	BSF	INTCON,GIE		; {͂Ŋ荞݂

	RETURN

EEPSC_010:				; EEPROMۑǏn
	BCF	PIR1,EEIF		; EEPROM݊荞݃tONA
	BANK1				; BANK 1 I
	BCF	EECON1,WREN		; Write Enable OFF
	BANK0				; BANK 0 I

	GOTO	EEPSC_001

;
;	EEPROMݒlǂݏo
;
EEP_READ:
	BANK1				; BANK 1 I
	CLRF	EEADR			; ǂݏoAhXZbg  0Ԓn
	BSF	EECON1,RD		; Read Go!
	MOVF	EEDATA,W		; ݒl𓾂
	BANK0				; BANK 0 I

	MOVWF	OUTVAL			; ϊlƂĊi[
	ADDLW	.0 - KEY_MAXVALUE - .1	; ől𒴂ĂȂ
	SKIPC
	RETURN				; NC: ϊl͔͈͓
					; C: ől𒴂Ă
	MOVLW	KEY_MAXVALUE		; lőlɊۂ߂
	MOVWF	OUTVAL

	RETURN

;
;	EEPROM ۑ܂ő҂
;
EEP_SAVEWAIT:
	BTFSS	PIR1,EEIF		; EEPROM݊荞݃tOON
	GOTO	EEP_SAVEWAIT		; OFFȂONɂȂ܂ŌJԂ

	BCF	PIR1,EEIF		; EEPROM݊荞݃tONA
	BANK1				; BANK 1 I
	BCF	EECON1,WREN		; Write Enable OFF
	BANK0				; BANK 0 I

	RETURN

;
;	荞݃[`
;
;	Ӂ@݂̓_~[ł
;
INTERRUPT:
	MOVWF	WSAVE			; Wregۑ
	SWAPF	STATUS,W		; STATUSۑ
	MOVWF	SSAVE
	MOVF	FSR,W			; FSRۑ
	MOVWF	FSAVE

	BANK0				; BANK 0 I
					; Ɋ荞ݏւ̕Lq
	MOVF	FSAVE,W
	MOVWF	FSR			; FSRA
	SWAPF	SSAVE,W
	MOVWF	STATUS			; STATUSA
	SWAPF	WSAVE,F			; WregA
	SWAPF	WSAVE,W			; Zflagی̂SWAPFgp
	RETFIE

	END
